/* RTOS Tasks, pipes, ...*/

#include "rtos_tasks.h"

/*###############################################################*/
// lcd related stuff
char lcd_buff[33] = "                                ";
char *lcd_string=lcd_buff;
void lcd_driver(void *args){
	int i, done=0;
	lcd_write_comm(DDRAM | 0x00);  
	for(i = 0; i < 16; i++){
    if(lcd_string[i]=='\0')
      done=1;
    if(done)
      lcd_write_data(' ');
    else
      lcd_write_data(lcd_string[i]);
  }
	lcd_write_comm(DDRAM | 0x40);
	for(; i < 32; i++){
    if(lcd_string[i]=='\0')
      done=1;
    if(done)
      lcd_write_data(' ');
    else
      lcd_write_data(lcd_string[i]);    
  }
}

void lcd_driver_short(void *args){
  static unsigned int i = 0;
  if(i==0){
    lcd_write_comm(DDRAM | 0x00);
  }
  else if(i==16){
    lcd_write_comm(DDRAM | 0x40);
  }
  lcd_write_data(lcd_string[i]);
  i = (i+1)%32;  
}

/*###############################################################*/
// keys related stuff



/*###############################################################*/
// uart stuff

