# -*- coding: UTF-8 -*-
# Lukšan-Vlček nonsmooth problems test suites

from pyopus.problems.lvns import *

if __name__=='__main__':
	print("Unconstrained minimax problems")
	for ii in range(len(UMM.names)):
		prob=UMM(number=ii)
		
		# These problems need setting up before they are used. 
		# Only one problem can be uset at a time. 
		prob.setup()
		
		print(f"{ii:2d}: {prob.name:20s} n={prob.n:2d}: f0={prob.f(prob.initial):e}")
	print()
	
	print("Unconstrained nonsmooth problems")
	for ii in range(len(UNS.names)):
		prob=UNS(number=ii)
		
		# These problems need setting up before they are used. 
		# Only one problem can be uset at a time. 
		prob.setup()
		
		print(f"{ii:2d}: {prob.name:20s} n={prob.n:2d}: f0={prob.f(prob.initial)[0]:e}")
	print()
	
	print("Linearly constrained minimax problems")
	for ii in range(len(LCMM.names)):
		prob=LCMM(number=ii)
		
		# These problems need setting up before they are used. 
		# Only one problem can be uset at a time. 
		prob.setup()
		
		print(f"{ii:2d}: {prob.name:20s} n={prob.n:2d}: f0={prob.f(prob.initial):e}")
	print()


