# Dispatches a fixed number of tasks to computational nodes
# Run it by typing
#  mpirun -n 4 python3 03-dispatch.py
# If you run it with 
#  python3 03-dispatch.py
# only the local processor will be used. 
#
# Under Windows you should use Microsoft MPI. mpiexec and python should be in 
# the system path. 
#
#   mpiexec /np <number of processes> python 03-dispatch.py

from pyopus.parallel.cooperative import cOS
from pyopus.parallel.mpi import MPI
from funclib import jobProcessor

if __name__=='__main__':
	# Set up MPI
	cOS.setVM(MPI())
	
	# This generator produces 100 jobs which are tuples of the form
	#   (function, args)
	jobGen=((jobProcessor, [value]) for value in range(100))
	
	# Dispatch jobs and collect results
	results=cOS.dispatch(jobList=jobGen, remote=True)

	# Results are put in the list in the ame order as the jobs are generated by jobGen
	print("Results: "+str(results))

	# Finish, need to do this if MPI is used
	cOS.finalize()
