# Nominal design

from definitions import *
from pyopus.design.cbd import CornerBasedDesign
from pyopus.evaluator.aggregate import formatParameters
# If MPI is imported an application not using MPI will behave correctly
# (i.e. only slot 0 will run the program) even when started with mpirun/mpiexec
from pyopus.parallel.mpi import MPI
from pyopus.parallel.cooperative import cOS


if __name__=='__main__':
	# Prepare statistical parameters dictionary with nominal values (0)
	nominalStat={ name: 0.0 for name, desc in statParams.items() }
	
	# Prepare operating parameters dictionary with nominal values
	nominalOp={ name: desc['init'] for name, desc in opParams.items() }
	
	# Prepare initial design parameters dictionary
	initialDesign={ name: desc['init'] for name, desc in designParams.items() }
	
	# Prepare one corner, module 'tm', nominal op parameters, defined for all heads
	corners={
		'nom': {
			'params': nominalOp, 
			'modules': ['tm']
		}
	}
	
	# Prepare parallel environment
	cOS.setVM(MPI(mirrorMap={'*':'.'}))
	
	# Design it, nominal statistical parameters are treated as fixed parameters
	cbd=CornerBasedDesign(
		designParams, heads, analyses, measures, corners, 
		fixedParams=[nominalStat], variables=variables, norms={ 'area': 100e-12 }, 
		initial=initialDesign, 
		method='global', 
		evaluatorOptions={'debug': 0}, 
		debug=1
	)
	
	# Run optimization
	atDesign, aggregator, analysisCount = cbd()
	
	# Print design parameters and performance measures
	print(formatParameters(atDesign))
	print(aggregator.formatResults())
	
	# Finalize cOS parallel environment
	cOS.finalize()
	
# Result 
#           c_out:   2.7554246044009274e-13
#          diff_l:   9.4332202623440736e-07
#          diff_w:   2.3375795415811108e-06
#          load_l:   2.3756623135591577e-07
#          load_w:   1.6523320157643291e-06
#          mirr_l:   5.0644534672805594e-07
#         mirr_ld:   3.5547110328069054e-07
#          mirr_w:   2.0838039604494952e-05
#         mirr_wd:   1.1863736303639208e-06
#         mirr_wo:   1.4370964243926263e-05
#           out_l:   7.3090341922323614e-07
#           out_w:   7.6420261841316943e-05
#           r_out:   2.7964138841674735e+03
