# Yield targeting

from definitions import *
from pyopus.design.yt import YieldTargeting
from pyopus.evaluator.aggregate import formatParameters
# If MPI is imported an application not using MPI will behave correctly
# (i.e. only slot 0 will run the program) even when started with mpirun/mpiexec
from pyopus.parallel.mpi import MPI
from pyopus.parallel.cooperative import cOS


if __name__=='__main__':
	# Create corner with the Monte Carlo model
	corners={
		'mc': {
			'params': {}, 
			'modules': [ 'wcd' ]
		}
	}
		
	# Worst case performances (skip area, transistor op conditions, and auxiliary measures)
	wcList=list(measures.keys())
	wcList.sort()
	wcList.remove('area')
	wcList.remove('vgs_drv')
	wcList.remove('vds_drv')
	wcList.remove('gain_com')
	wcList.remove('gain_vdd')
	wcList.remove('gain_vss')
	
	# Initial point
	atDesign={
		'dif_l':   6.9687740847716876e-07, 
		'dif_w':   2.4793794967147379e-06, 
		'nl_l':   3.9166691267853081e-06, 
		'nl_w':   3.6590641890074195e-05, 
		'nm_l':   1.2380795743402092e-06, 
		'nm_w':   5.0733797700613833e-06, 
		'pm_l':   1.1462495424616752e-06, 
		'pm_w0':   6.2135241140503094e-06, 
		'pm_w1':   1.1020143630163364e-05, 
		'pm_w2':   3.6508696355310061e-05, 
		'pm_w3':   8.2180366604504237e-06, 
	}
	
	# Prepare parallel environment
	cOS.setVM(MPI(mirrorMap={'*':'.'}))
	
	# 3-sigma target yield
	yt=YieldTargeting(
		designParams, statParams, opParams, 
		heads, analyses, measures, corners, variables=variables, 
		beta=3.0, wcSpecs=wcList, 
		# Comment out to use default initial point (lo+hi)/2
		initial=atDesign, 
		initialNominalDesign=False, 
		# Norms for measures with zero goal
 		#norms={ 'area': 100e-12, 'vgs_drv': 1e-3, 'vds_drv':1e-3 }, 
		#tradeoffs=1e-6, # Tradeoff optimization weight, can be overridden in *CbdOptions
		# Initial nominal optimization
		initialCbdOptions={ 
			'debug': 1, 'method': 'global', 'stepTol': 1e-5, 
		}, 
		# Main optimization
		cbdOptions={ 
			'debug': 1, 'method': 'global', 'stepTol': 1e-5, 
		}, wcOptions={ 'debug': 0 }, 
		debug=2, spawnerLevel=1
	)
	atDesign, agg, wc, anCount = yt()
	print(formatParameters(atDesign))
	print(wc.formatResults())
	print(agg.formatResults())
	print(anCount)
	
	# Finalize cOS parallel environment
	cOS.finalize()
	
